#version 150

in vec4 vertexColor;
in vec3 Position;
in vec3 ChunkOffset;
uniform mat4 ModelViewMat;
uniform mat4 ProjMat;

uniform vec4 ColorModulator;
uniform float GameTime;


out vec4 fragColor;

void main() {
    vec3 position = Position;
    float animation = GameTime * 2000;

    float redValue = sin((0.03125) + animation);
	float greenValue = sin((0.03125) + animation + 7.5);
	float blueValue = sin((0.03125) + animation + 15);
    
    fragColor = vec4(redValue * redValue, greenValue * greenValue, blueValue * blueValue, 1.0);
    //fragColor = vec4(position, 1.0);

    if(vertexColor.xyz != vec3(0.0))
        fragColor = vertexColor * ColorModulator;
}
