#version 150

in vec3 Position;
in vec4 Color;
in vec3 Normal;

uniform mat4 ModelViewMat;
uniform mat4 ProjMat;
uniform float LineWidth;
uniform vec2 ScreenSize;
uniform vec3 ChunkOffset;


out vec4 vertexColor;

void main() {
    vec3 position = Position;
    //vDistance = length((ModelViewMat * vec4(position + ChunkOffset, 1.0)).xyz);
    //position.y -= (vDistance - 1) / 8;

    vec4 linePosStart = ProjMat * ModelViewMat * vec4(position, 1.0);
    vec4 linePosEnd = ProjMat * ModelViewMat * vec4(position + Normal, 1.0);

    vec3 ndc1 = linePosStart.xyz / linePosStart.w;
    vec3 ndc2 = linePosEnd.xyz / linePosEnd.w;

    vec2 lineScreenDirection = normalize((ndc2.xy - ndc1.xy) * ScreenSize);
    vec2 lineOffset = vec2(-lineScreenDirection.y, lineScreenDirection.x) * LineWidth / ScreenSize;

    if (gl_VertexID % 2 == 0) {
        gl_Position = vec4((ndc1 + vec3(lineOffset, 0.0)) * linePosStart.w, linePosStart.w);
    } else {
        gl_Position = vec4((ndc1 - vec3(lineOffset, 0.0)) * linePosStart.w, linePosStart.w);
    }

    vertexColor = Color;
}
